***CRCB
***May 11, 2021


***corruption & deaths


gen sptx= total_cases/ total_tests

label define clabel 1 "ALB" 2 "AND"  3"ARG" 4"AUS" 5"AUT" 6"BEL" 7"BGR" 8"BIH" 9"BLR" 10"CAN" 11"CHE" 12"CHL" 13"CYP" 14"CZE" 15"DEU" 16"DNK" 17"ESP" 18"EST" 19"FIN" 20"FRA" 21"GBR" 22"GRC" 23"HRV" 24"HUN" 25"IRL" 26"ISL" 27"ISR" 28"ITA" 29"JPN" 30"LIE" 31"LTU" 32"LUX" 33"LVA" 34"MDA" 35"MKD" 36"MLT" 37"MNE" 38"NLD" 39"NOR" 40"NZL" 41"POL" 42"PRT" 43"ROU" 44"RUS" 45"SRB" 46"SVK" 47"SVN" 48"SWE" 49"UKR" 50"USA" 51"XKX" 52"ZAF" 53"HUN*"
label values id clabel

gen hu=0
replace hu=1 if id==24
gen c_ti= 88 -  cpis_2019
gen c_wb= 2.170072 -  cc_2019
gen c_wef_eos=94 - wef


xtile q_spt    =spt       if sample==1, n(5)
xtile q_tdpm   =tdpm      if sample==1, n(5)
xtile q_cc_2019=cc_2019   if sample==1, n(5)
xtile q_cpi    =cpis_2019 if sample==1, n(5)

***Fig. 1. 

reg c_wef_eos bfs imd_wcy if eu==1, beta
hettest
vif
predict c_wef_eos_x, xb
replace c_wef_eos=c_wef_eos_x if id==6

graph twoway (scatter cdr_un c_wef_eos if hu==1 & eu==1, msymbol (O) mcolor(orange) msize(small) mlabel(id)) (scatter cdr_un c_wef_eos if hu==0 & eu==1, msymbol(Oh) msize(small) mlabel(id)) ||, legend(label(1 Hungary) label(2 other EU countries)) xlabel(, nogrid) xtitle("level of corruption by WEF EOS - 2019") ytitle("crude deaths rate - 2019") ylabel(, nogrid) note("Source: CRCB's own calculations based on WEF and UN data", size(tiny)) graphregion( color(white))

list id country cdr_un c_wef_eos if eu==1
pwcorr cdr_un c_wef_eos if eu==1, sig o
reg cdr_un c_wef_eos if eu==1, beta
hettest
vif
reg cdr_un c_wef_eos gdp_pcap_usd_wb_2019 if eu==1, beta
hettest
vif

***Fig. 2.


graph twoway (scatter tdpm c_wef_eos if eu==1 & hu==0, msymbol(Oh) msize(small) mlabel(id)) ||, xlabel(, nogrid) xtitle("level of corruption by WEF EOS - 2019") ytitle("Covid-19 deaths per 1 million pop.") ylabel(, nogrid) note("Source: CRCB's estimations and calculations based on WEF and Our World in Data", size(tiny)) graphregion( color(white))

list id country tdpm c_wef_eos if eu==1
pwcorr tdpm c_wef_eos if eu==1, sig o

***Fig. 3.

graph twoway (scatter tdpm spt if eu==1 & hu==0, msymbol(Oh) msize(small) mlabel(id)) ||, xlabel(, nogrid) xtitle("positivity rate") ytitle("Covid-19 deaths per 1 million pop.") ylabel(, nogrid) note("Source: CRCB's estimations and calculations based on WEF and Our World in Data", size(tiny)) graphregion( color(white))
pwcorr tdpm spt if eu==1, sig o
list id country tdpm spt if eu==1 & hu==0

***Fig. 4a-b.

graph twoway (scatter tdpm c_wef_eos if hu==1 & eu==1, msymbol (O) mcolor(orange) msize(small) mlabel(id)) (scatter tdpm c_wef_eos if hu==0 & eu==1, msymbol(Oh) msize(small) mlabel(id)) ||, legend(label(1 Hungary) label(2 other EU countries)) xlabel(, nogrid) xtitle("level of corruption by WEF EOS - 2019") ytitle("Covid-19 deaths per 1 million pop.") ylabel(, nogrid) note("Source: CRCB's own calculations based on WEF and Our World in Data", size(tiny)) graphregion( color(white))

graph twoway (scatter tdpm spt if hu==1 & eu==1, msymbol (O) mcolor(orange) msize(small) mlabel(id)) (scatter tdpm spt if hu==0 & eu==1, msymbol(Oh) msize(small) mlabel(id)) ||, legend(label(1 Hungary) label(2 other EU countries)) xlabel(, nogrid) xtitle("positivity rate") ytitle("Covid_19 deaths per 1 million pop.") ylabel(, nogrid) note("Source: CRCB's own calculations based on Our World in Data", size(tiny)) graphregion( color(white))

list id country tdpm spt if eu==1
reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 if eu==1, beta

***fig. 5.
***out-of-sample

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 if eu==1 & hu==0, beta
hettest
vif
predict tdpm_x, xb
predict tdpm_stdp, stdp

*** in-sample

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 if eu==1, beta
hettest
vif
predict tdpm_hun_x, xb
predict tdpm_hun_stdp, stdp


***ordinal variables

xtile q_spt    =spt          if sample==1, n(5)
xtile q_tdpm   =tdpm         if sample==1, n(5)
xtile q_c_wef_eos=c_wef_eos  if sample==1, n(5)


**estimations

***postitivity rate & corruption

reg tdpm spt c_wef_eos                      if eu==1, beta
reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 if eu==1, beta

***median age

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 median_age if eu==1, beta
hettest
vif

***age
***65 or older

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 aged_65_older if eu==1, beta
hettest
vif

***70 or older

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 aged_70_older if eu==1, beta
hettest
vif

***female smokers

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 female_smokers if eu==1, beta
hettest
vif

***male smokers

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 female_smokers if eu==1, beta
hettest
vif

***extreme poverty

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 xpov if eu==1, beta
hettest
vif

***cardiovasc death rate

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 cdr if eu==1, beta
hettest
vif

***diabetes 

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 diabetes if eu==1, beta
hettest
vif

***human development index 

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 hdi if eu==1, beta
hettest
vif

***population densitiy 

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 population_density if eu==1, beta
hettest
vif

***crude death rate in 2019

reg tdpm spt c_wef_eos gdp_pcap_usd_wb_2019 cdr_un if eu==1, beta
hettest
vif


***estimations

ologit q_tdpm q_spt q_c_wef_eos gdp_pcap_usd_wb_2019 if eu==1
reg    q_tdpm q_spt q_c_wef_eos gdp_pcap_usd_wb_2019 if eu==1, beta

***end
