***
***2025_craefippaems_2007_2023
***ijt & mh
***November 24, 2025
***


***
***Corruption Risk and EU Funding in Public Procurement Across EU Member States, 2007–2023
***

***
*** CONTRACT LEVEL ANALYSIS
***

***use "###\2025_craefippaems_2007_2023_contract_level_data.dta, clear"

*gen nbid=.
*replace nbid=number_offers if number_offers<=31
*replace nbid=. if nbid==0
*tab nbid

*gen nbidx=.
*replace nbidx=1 if nbid==1
*replace nbidx=2 if nbid>1  & nbid<4
*replace nbidx=3 if nbid>3  & nbid<8
*replace nbidx=4 if nbid>7  & nbid<16
*replace nbidx=5 if nbid>15 & nbid<=32

*gen ccode=country

*gen      g_hr=1
*replace  g_hr=0 if country=="HR" & year<2013

*gen eu_lti      =eu*lti
*gen eu_lnncv    =eu*lnncv
*gen eu_gpa      =eu*gpa
*gen eu_eauction =eu*eauction
*drop if year==2006

***
***Table 3.1
***

tabstat cr     if eu==0        & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat crx    if eu==0        & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat cr     if eu==1        & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat crx    if eu==1        & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat cr     if lti==0       & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat crx    if lti==0       & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat cr     if lti==1       & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat crx    if lti==1       & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat cr     if gpa==0       & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat crx    if gpa==0       & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat cr     if gpa==1       & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat crx    if gpa==1       & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat cr     if eauction==0  & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat crx    if eauction==0  & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat cr     if eauction==1  & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)
tabstat crx    if eauction==1  & eu_countries_d==1 & goodfw==1 & year>2006         , stat(mean sem n)

***
***Figures 4.1.1a - 4.1.1d
***

gen nbid_eu0=nbid
gen nbid_eu1=nbid + 0.1

*"Histogram of Number of Bidders (NBID) by Type of Funding"
twoway (hist nbid if goodfw==1 & eu==0 & nbid<13 & year>2006, percent color(gray*0.3) fcolor(gray*0.3)  bin(12)) (hist nbid if goodfw==1 & eu==1 & nbid<13& year>2006, percent color(black*1.5) fcolor(none) bin(12)), legend(off) xtitle("NBID (shaded with gray: nationally funded; black blank: EU-funded)", size (medium)) graphregion( color(white)) note("Notes: Only contracts where NBID<13; N=6,181,667", size(medium))
*graph export "###\f411a_histogram_nbid_eu_all.png", as(png) name("Graph") replace

*"Histogram of Number of Bidders (NBID) by Type of Funding" "in New Member States from 2007 to 2023"
twoway (histogram nbid if goodfw==1 & eu==0 & nms==1 & nbid<13 & year>2006, color(gray*0.3) fcolor(gray*0.3) bin(12)) (histogram nbid if goodfw==1 & eu==1 & nms==1 & nbid<13 & year>2006, color(black*1.5) fcolor(none) bin(12)), legend(off) xtitle("NBID (shaded with gray: nationally funded; black blank: EU-funded)", size (medium))  graphregion( color(white)) note("Notes: Only contractrs where NBID<13; N=3,411,889", size(medium))
*graph export "###\f411b_histogram_nbid_eu_nms.png", as(png) name("Graph") replace

*"Histogram of Number of Bidders (NBID) by Type of Funding" "in Western European Countries from 2007 to 2023"
twoway (hist nbid if goodfw==1 & eu==0 & wec==1 & nbid<13 & year>2006, percent color(gray*0.3) fcolor(gray*0.3) bin(12)) (hist nbid if goodfw==1 & eu==1 & wec==1 & nbid<13 & year>2006, percent color(black*1.5) fcolor(none) bin(12)), legend(off) xtitle("NBID (shaded with gray: nationally funded; black blank: EU-funded)", size (medium)) graphregion( color(white)) note("Notes: Only contracts where where NBID<13; N=2,002,522", size(medium))
*graph export "###\f411c_histogram_nbid_eu_wec.png", as(png) name("Graph") replace

*"Histogram of Number of Bidders (NBID) by Type of Funding" "in Southern European Countries from 2007 to 2023"
twoway (hist nbid if goodfw==1 & eu==0 & sec==1 & nbid<13 & year>2006, color(gray*0.3) fcolor(gray*0.3) bin(12)) (hist nbid if goodfw==1 & eu==1 & sec==1 & nbid<13 & year>2006, color(black*1.5) fcolor(none) bin(12)), legend(off) xtitle("NBID (shaded with gray: nationally funded; black blank: EU-funded)", size (medium))  graphregion( color(white)) note("Notes: Only contracts where NBID<13; N=692,671", size(medium))
*graph export "###\f411d_histogram_nbid_eu_sec.png", as(png) name("Graph") replace

***
***Table 4.1.1
***

tabstat cr     if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, stat(mean sd n)
tabstat cr     if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, stat(mean sd n)
tabstat cr     if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, stat(mean sd n)
tabstat cr     if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006         , stat(mean sd n)

tabstat crx    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, stat(mean sd n)
tabstat crx    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, stat(mean sd n)
tabstat crx    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, stat(mean sd n)
tabstat crx    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006         , stat(mean sd n)

tabstat eu     if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, stat(mean sd n)
tabstat eu     if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, stat(mean sd n)
tabstat eu     if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, stat(mean sd n)
tabstat eu     if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006         , stat(mean sd n)

tabstat lti    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, stat(mean sd n)
tabstat lti    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, stat(mean sd n)
tabstat lti    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, stat(mean sd n)
tabstat lti    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006         , stat(mean sd n)

tabstat lnncv  if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, stat(mean sd n)
tabstat lnncv  if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, stat(mean sd n)
tabstat lnncv  if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, stat(mean sd n)
tabstat lnncv  if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006         , stat(mean sd n)

tabstat gpa    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, stat(mean sd n)
tabstat gpa    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, stat(mean sd n)
tabstat gpa    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, stat(mean sd n)
tabstat gpa    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006         , stat(mean sd n)

tabstat eauction if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, stat(mean sd n)
tabstat eauction if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, stat(mean sd n)
tabstat eauction if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, stat(mean sd n)
tabstat eauction if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006         , stat(mean sd n)

tabstat nbidx    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, stat(mean sd n)
tabstat nbidx    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, stat(mean sd n)
tabstat nbidx    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, stat(mean sd n)
tabstat nbidx    if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006         , stat(mean sd n)

***
***Table 4.1.3
***

pwcorr cr crx eu lti lnncv gpa eauction if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006, star(0.01)

***
*** Estimations
***

***
***Table 4.2.1
***

logit  cr   eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006, or robust
logit  cr   eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, or robust
logit  cr   eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, or robust
logit  cr   eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, or robust
logit  crx  eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006, or robust
logit  crx  eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, or robust
logit  crx  eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, or robust
logit  crx  eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, or robust

***
***Table 4.2.2
***

logit  cr eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006, or robust
logit  cr eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, or robust
logit  cr eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, or robust
logit  cr eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, or robust
logit  crx eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006, or robust
logit  crx eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, or robust
logit  crx eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, or robust
logit  crx eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, or robust

***
***Table 4.2.3
***

logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="BG", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="CZ", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="EE", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="HR", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="HU", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="LT", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="LV", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & year>2006 & country=="PL", or
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="RO", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="SI", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="SK", or robust

***
***Table 4.2.4
***

logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="CY", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="GR", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="IT", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="MT", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="PT", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="ES", or robust

***
***Table 4.2.5
***

logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="AT", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="BE", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="DE", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="DK", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="FI", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="FR", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="IE", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="LU", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="NL", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="SE", or robust
logit  cr  eu lti lnncv gpa eauction i.sector i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & country=="UK", or robust

***
***Fig. 4.2.1
***

logit  cr  eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006, or robust
logit  crx eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006, or robust

**putting results to an excel file (fig421.xlsx)

clear
*import excel "###\fig421.xlsx", sheet("Sheet1") firstrow
gen odds_neutral=1
tsset id
graph         bar or, over(variables) over(cr_crx)
graph twoway (bar or variables) (rcap or_hi or_lo variables), by(cr_crx)
gen      var_crcrx=variables    if cr_crx==1
replace  var_crcrx=variables+6  if cr_crx==2
twoway (bar or var_crcrx)
twoway (bar or var_crcrx) (rcap or_hi  or_lo var_crcrx)

twoway (bar or var_crcrx if variables==1, color(gray)) (bar or var_crcrx if variables==2, color(gray*0.8)) (bar or var_crcrx if variables==3, color(gray*0.6)) (bar or var_crcrx if variables==4, color(gray*0.4)) (bar or var_crcrx if variables==5, color(gray*0.2)) (rcap or_hi or_lo var_crcrx, color(black)) (tsline odds_neutral, color(black)) (scatter or id, msymbol(none) mlabel(or) mlabposition(12) mlabcolor(gray)), legend(row(1) order(1 "EU" 2 "LTI" 3 "LNNCV" 4 "GPA" 5 "EAUCTION" 6 "95%CI") position (6)) xlabel( 3 "CR" 9 "CRX", noticks) xtitle("Corruption Risk Indicators") ytitle("Odds Ratio") note("Notes: odds ratio at 1: no effect; from models without interaction terms; N = 5,029,979", size(small))
*graph export "###\f421_bar_crr_crr_or.png", as(png) name("Graph") replace


***use "###\2025_craefippaems_2007_2023_contract_level_data.dta, clear"

***
***Table A3.1
***

probit cr   eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006, vce(robust)
probit cr   eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, vce(robust)
probit cr   eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, vce(robust)
probit cr   eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, vce(robust)
probit crx  eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006, vce(robust)
probit crx  eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, vce(robust)
probit crx  eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, vce(robust)
probit crx  eu lti lnncv gpa eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, vce(robust)


***
***Fig. A3.1
***

gen nbidx_eu0=nbidx
gen nbidx_eu1=nbidx + 0.1
twoway (hist nbidx_eu0 if goodfw==1 & eu==0 & year>2006, percent color(gray*0.6) fcolor(gray*0.6)  bin(15)) (hist nbidx_eu1 if goodfw==1 & eu==1 & year>2006, percent color(black) fcolor(none) bin(15)), legend(off) xtitle("NBIDX (shaded with gray: nationally funded; black blank: EU-funded)", size (medium)) graphregion( color(white)) note("Note: N=6,499,998", size(medium))
*graph export "###\f31_histogram_nbidx_eu0_eu1.png", as(png) name("Graph") replace


***
***Table A3.2
***

ologit nbidx eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006, or vce(robust)
ologit nbidx eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & nms==1, or vce(robust)
ologit nbidx eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & sec==1, or vce(robust)
ologit nbidx eu lti lnncv gpa eauction eu_lti eu_lnncv eu_gpa eu_eauction i.sector i.eu_countries i.year if eu_countries_d==1 & goodfw==1 & g_hr==1 & year>2006 & wec==1, or vce(robust)


***
***Table A3.3
***

mrobust logit  cr  eu lti    lnncv              gpa        eauction          if eu_countries_d==1 & goodfw==1 & year>2006 & g_hr==1
*graph save "Graph" "###\mrobust_011.gph", replace

mrobust logit  cr  eu lti    lnncv              gpa        eauction          if eu_countries_d==1 & goodfw==1 & year>2006 & nms==1 & g_hr==1
*graph save "Graph" "###\mrobust_012.gph", replace

mrobust logit  cr  eu lti    lnncv              gpa        eauction          if eu_countries_d==1 & goodfw==1 & year>2006 & sec==1 & g_hr==1
*graph save "Graph" "###\mrobust_013.gph", replace

mrobust logit  cr  eu lti    lnncv              gpa        eauction          if eu_countries_d==1 & goodfw==1 & year>2006 & wec==1 & g_hr==1
*graph save "Graph" "###\mrobust_014.gph", replace

mrobust logit  crx  eu lti    lnncv              gpa        eauction         if eu_countries_d==1 & goodfw==1 & year>2006 & g_hr==1
*graph save "Graph" "###\mrobust_015.gph", replace

mrobust logit  crx  eu lti    lnncv              gpa        eauction         if eu_countries_d==1 & goodfw==1 & year>2006 & nms==1 & g_hr==1
*graph save "Graph" "###\mrobust_016.gph", replace

mrobust logit  crx  eu lti    lnncv              gpa        eauction         if eu_countries_d==1 & goodfw==1 & year>2006 & sec==1 & g_hr==1
*graph save "Graph" "###\mrobust_017.gph", replace

mrobust logit  crx  eu lti    lnncv              gpa        eauction         if eu_countries_d==1 & goodfw==1 & year>2006 & wec==1 & g_hr==1
*graph save "Graph" "###\mrobust_018.gph", replace

***

mrobust logit  cr  eu lti    lnncv              gpa        eauction i.eu_countries         if eu_countries_d==1 & goodfw==1 & year>2006 & g_hr==1
*graph save "Graph" "###\mrobust_021.gph", replace

mrobust logit  cr  eu lti    lnncv              gpa        eauction i.eu_countries         if eu_countries_d==1 & goodfw==1 & year>2006 & nms==1 & g_hr==1
*graph save "Graph" "###\mrobust_022.gph", replace

mrobust logit  cr  eu lti    lnncv              gpa        eauction i.eu_countries         if eu_countries_d==1 & goodfw==1 & year>2006 & sec==1 & g_hr==1
*graph save "Graph" "###\mrobust_023.gph", replace

mrobust logit  cr  eu lti    lnncv              gpa        eauction i.eu_countries         if eu_countries_d==1 & goodfw==1 & year>2006 & wec==1 & g_hr==1
*graph save "Graph" "###\mrobust_024.gph", replace

mrobust logit  crx  eu lti    lnncv              gpa        eauction i.eu_countries         if eu_countries_d==1 & goodfw==1 & year>2006 & g_hr==1
*graph save "Graph" "###\mrobust_025.gph", replace

mrobust logit  crx  eu lti    lnncv              gpa        eauction i.eu_countries         if eu_countries_d==1 & goodfw==1 & year>2006 & nms==1 & g_hr==1
*graph save "Graph" "###\mrobust_026.gph", replace

mrobust logit  crx  eu lti    lnncv              gpa        eauction i.eu_countries         if eu_countries_d==1 & goodfw==1 & year>2006 & sec==1 & g_hr==1
*graph save "Graph" "###\mrobust_027.gph", replace

mrobust logit  crx  eu lti    lnncv              gpa        eauction i.eu_countries         if eu_countries_d==1 & goodfw==1 & year>2006 & wec==1 & g_hr==1
*graph save "Graph" "###\mrobust_028.gph", replace

***

mrobust logit  cr  eu lti eu_lti  lnncv          gpa eu_gpa eauction eu_eauction if eu_countries_d==1 & goodfw==1 & year>2006 & g_hr==1
*graph save "Graph" "###\mrobust_031.gph", replace

mrobust logit  cr  eu lti eu_lti  lnncv          gpa eu_gpa eauction eu_eauction if eu_countries_d==1 & goodfw==1 & year>2006 & nms==1 & g_hr==1
*graph save "Graph" "###\mrobust_032.gph", replace

mrobust logit  cr  eu lti eu_lti  lnncv          gpa eu_gpa eauction eu_eauction if eu_countries_d==1 & goodfw==1 & year>2006 & sec==1 & g_hr==1
*graph save "Graph" "###\mrobust_033.gph", replace

mrobust logit  cr  eu lti eu_lti  lnncv          gpa eu_gpa eauction eu_eauction if eu_countries_d==1 & goodfw==1 & year>2006 & wec==1 & g_hr==1
*graph save "Graph" "###\mrobust_034.gph", replace

mrobust logit  crx  eu lti eu_lti  lnncv          gpa eu_gpa eauction eu_eauction if eu_countries_d==1 & goodfw==1 & year>2006 & g_hr==1
*graph save "Graph" "###\mrobust_035.gph", replace

mrobust logit  crx  eu lti eu_lti  lnncv          gpa eu_gpa eauction eu_eauction if eu_countries_d==1 & goodfw==1 & year>2006 & nms==1 & g_hr==1
*graph save "Graph" "###\mrobust_036.gph", replace

mrobust logit  crx  eu lti eu_lti  lnncv          gpa eu_gpa eauction eu_eauction if eu_countries_d==1 & goodfw==1 & year>2006 & sec==1 & g_hr==1
*graph save "Graph" "###\mrobust_037.gph", replace

mrobust logit  crx  eu lti eu_lti  lnncv          gpa eu_gpa eauction eu_eauction if eu_countries_d==1 & goodfw==1 & year>2006 & wec==1 & g_hr==1
*graph save "Graph" "###\mrobust_038.gph", replace

***
*** END OF THE CONTRACT LEVEL ANALYSIS
***

***
*** COUNTRY LEVEL ANALYSIS
***

***
*** datatable creation
***


**
**creation of country level datatable
**

*use  "###\2025_craefippaems_2007_2023_contract_level_data.dta, clear"

gen     cr0=0
replace cr0=1 if cr==0
gen     cr1=0
replace cr1=1 if cr==1

gen     cr0_eu0=0 if         eu==0
replace cr0_eu0=1 if cr==0 & eu==0
gen     cr1_eu0=0 if         eu==0
replace cr1_eu0=1 if cr==1 & eu==0

gen     cr0_eu1=0 if         eu==1
replace cr0_eu1=1 if cr==0 & eu==1
gen     cr1_eu1=0 if         eu==1
replace cr1_eu1=1 if cr==1 & eu==1

gen     crx0=0
replace crx0=1 if crx==0
gen     crx1=0
replace crx1=1 if crx==1

gen     crx0_eu0=0 if          eu==0
replace crx0_eu0=1 if crx==0 & eu==0
gen     crx1_eu0=0 if          eu==0
replace crx1_eu0=1 if crx==1 & eu==0

gen     crx0_eu1=0 if          eu==1
replace crx0_eu1=1 if crx==0 & eu==1
gen     crx1_eu1=0 if          eu==1
replace crx1_eu1=1 if crx==1 & eu==1

gen     eu0=0
replace eu0=1 if eu==0
gen     eu1=0
replace eu1=1 if eu==1

gen     lti0=0
replace lti0=1 if lti==0
gen     lti1=0
replace lti1=1 if lti==1

gen     lti0_eu0=0 if          eu==0
replace lti0_eu0=1 if lti==0 & eu==0
gen     lti1_eu0=0 if          eu==0
replace lti1_eu0=1 if lti==1 & eu==0

gen     lti0_eu1=0 if          eu==1
replace lti0_eu1=1 if lti==0 & eu==1
gen     lti1_eu1=0 if          eu==1
replace lti1_eu1=1 if lti==1 & eu==1

gen     gpa0=0
replace gpa0=1 if gpa==0
gen     gpa1=0
replace gpa1=1 if gpa==1

gen     gpa0_eu0=0 if          eu==0
replace gpa0_eu0=1 if gpa==0 & eu==0
gen     gpa1_eu0=0 if          eu==0
replace gpa1_eu0=1 if gpa==1 & eu==0

gen     gpa0_eu1=0 if          eu==1
replace gpa0_eu1=1 if gpa==0 & eu==1
gen     gpa1_eu1=0 if          eu==1
replace gpa1_eu1=1 if gpa==1 & eu==1

gen     eauction0=0
replace eauction0=1 if eauction==0
gen     eauction1=0
replace eauction1=1 if eauction==1

gen     eauction0_eu0=0 if               eu==0
replace eauction0_eu0=1 if eauction==0 & eu==0
gen     eauction1_eu0=0 if               eu==0 
replace eauction1_eu0=1 if eauction==1 & eu==0

gen     eauction0_eu1=0 if               eu==1
replace eauction0_eu1=1 if eauction==0 & eu==1
gen     eauction1_eu1=0 if               eu==1 
replace eauction1_eu1=1 if eauction==1 & eu==1

gen ncv_mill=ncvalue/1000000
gen ncv_millcr0= ncv_mill if cr==0
gen ncv_millcr1= ncv_mill if cr==1

gen ncv_mill_eu0   = ncvalue/1000000     if eu==0
gen ncv_millcr0_eu0= ncv_mill            if cr==0   &  eu==0
gen ncv_millcr1_eu0= ncv_mill            if cr==1   &  eu==0

gen ncv_mill_eu1   = ncvalue/1000000     if eu==1
gen ncv_millcr0_eu1= ncv_mill            if cr==0   &  eu==1
gen ncv_millcr1_eu1= ncv_mill            if cr==1   &  eu==1

gen cnum=1
gen cnum_eu0=1 if eu==0
gen cnum_eu1=1 if eu==1

gen eu_c=2

***eu_c[02]: all contracts
keep if goodfw==1
keep if eu_countries_d==1
keep if year>2006

keep country cr0 cr1 cr0_eu0 cr1_eu0 cr0_eu1 cr1_eu1 crx0 crx1 crx0_eu0 crx1_eu0 crx0_eu1 crx1_eu1 eu0 eu1 lti0 lti1 lti0_eu0 lti1_eu0 lti0_eu1 lti1_eu1 gpa0 gpa1 gpa0_eu0 gpa1_eu0 gpa0_eu1 gpa1_eu1 eauction0 eauction1 eauction0_eu0 eauction1_eu0 eauction0_eu1 eauction1_eu1 ncv_mill ncv_mill_eu0 ncv_mill_eu1 ncv_millcr0 ncv_millcr0_eu0 ncv_millcr0_eu1 ncv_millcr1 ncv_millcr1_eu0 ncv_millcr1_eu1 cnum cnum_eu0 cnum_eu1 eu_c eu_countries year 

collapse (first) country eu_c (sum) cr0 cr1 cr0_eu0 cr1_eu0 cr0_eu1 cr1_eu1 crx0 crx1 crx0_eu0 crx1_eu0 crx0_eu1 crx1_eu1 eu0 eu1 lti0 lti1 lti0_eu0 lti1_eu0 lti0_eu1 lti1_eu1 gpa0 gpa1 gpa0_eu0 gpa1_eu0 gpa0_eu1 gpa1_eu1 eauction0 eauction1 eauction0_eu0 eauction1_eu0 eauction0_eu1 eauction1_eu1 ncv_mill ncv_mill_eu0 ncv_mill_eu1 ncv_millcr0 ncv_millcr0_eu0 ncv_millcr0_eu1 ncv_millcr1 ncv_millcr1_eu0 ncv_millcr1_eu1 cnum cnum_eu0 cnum_eu1, by (eu_countries year)

format year %8.0g

gen crr     =cr1    /(cr1    +cr0)
gen crr_eu0 =cr1_eu0/(cr1_eu0+cr0_eu0)
gen crr_eu1 =cr1_eu1/(cr1_eu1+cr0_eu1)
gen eur     =eu1/(eu1+eu0)
gen crxr    =crx1/(crx1+crx0)
gen crxr_eu0 =crx1_eu0/(crx1_eu0+crx0_eu0)
gen crxr_eu1 =crx1_eu1/(crx1_eu1+crx0_eu1)
gen ltir     =lti1    /(lti1    +lti0)
gen ltir_eu0 =lti1_eu0/(lti1_eu0+lti0_eu0)
gen ltir_eu1 =lti1_eu1/(lti1_eu1+lti0_eu1)
gen gpar     =gpa1    /(gpa1    +gpa0)
gen gpar_eu0 =gpa1_eu0/(gpa1_eu0+gpa0_eu0)
gen gpar_eu1 =gpa1_eu1/(gpa1_eu1+gpa0_eu1)
gen eauctionr    =eauction1/(eauction1 + eauction0)
gen eauctionr_eu0=eauction1_eu0/(eauction1_eu0 + eauction0_eu0)
gen eauctionr_eu1=eauction1_eu1/(eauction1_eu1 + eauction0_eu1)
gen ncv_crr    =ncv_millcr1    /ncv_mill
gen ncv_crr_eu0=ncv_millcr1_eu0/ncv_mill_eu0
gen ncv_crr_eu1=ncv_millcr1_eu1/ncv_mill_eu1

gen lnncv    =ln(ncv_mill)
gen lnncv_eu0=ln(ncv_mill_eu0)
gen lnncv_eu1=ln(ncv_mill_eu1)

gen cgroups=.
replace cgroups=1  if country=="BG"
replace cgroups=1  if country=="CZ"
replace cgroups=1  if country=="EE"
replace cgroups=1  if country=="HR"
replace cgroups=1  if country=="HU"
replace cgroups=1  if country=="LT"
replace cgroups=1  if country=="LV"
replace cgroups=1  if country=="PL"
replace cgroups=1  if country=="RO"
replace cgroups=1  if country=="SI"
replace cgroups=1  if country=="SK"

replace cgroups=2  if country=="AT"
replace cgroups=2  if country=="BE"
replace cgroups=2  if country=="DE"
replace cgroups=2  if country=="DK"
replace cgroups=2  if country=="FI"
replace cgroups=2  if country=="FR"
replace cgroups=2  if country=="IE"
replace cgroups=2  if country=="LU"
replace cgroups=2  if country=="NL"
replace cgroups=2  if country=="SE"
replace cgroups=2  if country=="UK"

replace cgroups=3  if country=="CY"
replace cgroups=3  if country=="ES"
replace cgroups=3  if country=="GR"
replace cgroups=3  if country=="IT"
replace cgroups=3  if country=="MT"
replace cgroups=3  if country=="PT"

***nms (new member states)

gen     nms=.
replace nms=0  if cgroups==2 | cgroups==3
replace nms=1  if cgroups==1

**sec (southern european countries)

gen     sec=.
replace sec=0  if cgroups==2  | cgroups==1
replace sec=1  if cgroups==3

***wec (western european countries)

gen     wec=.
replace wec=0  if cgroups==1  | cgroups==3 
replace wec=1  if cgroups==2

gen     good=1
replace good=0 if country=="HR" & year==2007
replace good=0 if country=="HR" & year==2010
replace good=0 if country=="HR" & year==2011
replace good=0 if country=="HR" & year==2012
keep if good==1

***_02: all contracts 

*save "###\2025_craefippaems_2007_2023_country_level_data_s18_02.dta", replace
*use  "###\2025_craefippaems_2007_2023_contract_level_data.dta, clear"

keep if eu==0

gen     cr0=0
replace cr0=1 if cr==0
gen     cr1=0
replace cr1=1 if cr==1
gen     crx0=0
replace crx0=1 if crx==0
gen     crx1=0
replace crx1=1 if crx==1

gen     eu0=0
replace eu0=1 if eu==0
gen     eu1=0
replace eu1=1 if eu==1

gen     lti0=0
replace lti0=1 if lti==0
gen     lti1=0
replace lti1=1 if lti==1

gen     gpa0=0
replace gpa0=1 if gpa==0
gen     gpa1=0
replace gpa1=1 if gpa==1

gen     eauction0=0
replace eauction0=1 if eauction==0
gen     eauction1=0
replace eauction1=1 if eauction==1

gen ncv_mill=ncvalue/1000000
gen ncv_millcr0= ncv_mill if cr==0
gen ncv_millcr1= ncv_mill if cr==1

gen cnum=1
gen eu_c=0
***eu_c[0]: nationally financed
keep if goodfw==1
keep if eu_countries_d==1
keep if year>2006
keep country cr0 cr1 crx0 crx1 eu0 eu1 lti0 lti1 gpa0 gpa1 eauction0 eauction1 ncv_mill ncv_millcr0 ncv_millcr1 cnum eu_c eu_countries year
collapse (first) country eu_c (sum) cr0 cr1 crx0 crx1 eu0 eu1 lti0 lti1 gpa0 gpa1 eauction0 eauction1 ncv_mill ncv_millcr0 ncv_millcr1 cnum, by (eu_countries year)

format year %8.0g

gen crr =cr1/(cr1+cr0)
gen eur =0
gen crxr=crx1/(crx1+crx0)
gen ltir=lti1/(lti1+lti0)
gen gpar=gpa1/(gpa1+gpa0)
gen eauctionr=eauction1/(eauction1 + eauction0)
gen ncv_crr=ncv_millcr1/ncv_mill
gen lnncv=ln(ncv_mill)

gen cgroups=.
replace cgroups=1  if country=="BG"
replace cgroups=1  if country=="CZ"
replace cgroups=1  if country=="EE"
replace cgroups=1  if country=="HR"
replace cgroups=1  if country=="HU"
replace cgroups=1  if country=="LT"
replace cgroups=1  if country=="LV"
replace cgroups=1  if country=="PL"
replace cgroups=1  if country=="RO"
replace cgroups=1  if country=="SI"
replace cgroups=1  if country=="SK"

replace cgroups=2  if country=="AT"
replace cgroups=2  if country=="BE"
replace cgroups=2  if country=="DE"
replace cgroups=2  if country=="DK"
replace cgroups=2  if country=="FI"
replace cgroups=2  if country=="FR"
replace cgroups=2  if country=="IE"
replace cgroups=2  if country=="LU"
replace cgroups=2  if country=="NL"
replace cgroups=2  if country=="SE"
replace cgroups=2  if country=="UK"

replace cgroups=3  if country=="CY"
replace cgroups=3  if country=="ES"
replace cgroups=3  if country=="GR"
replace cgroups=3  if country=="IT"
replace cgroups=3  if country=="MT"
replace cgroups=3  if country=="PT"

***nms (new member states)

gen     nms=.
replace nms=0  if cgroups==2 | cgroups==3
replace nms=1  if cgroups==1

**sec (southern european countries)

gen     sec=.
replace sec=0  if cgroups==2  | cgroups==1
replace sec=1  if cgroups==3

***wec (western european countries)

gen     wec=.
replace wec=0  if cgroups==1  | cgroups==3 
replace wec=1  if cgroups==2

gen     good=1
replace good=0 if country=="HR" & year==2007
replace good=0 if country=="HR" & year==2010
replace good=0 if country=="HR" & year==2011
replace good=0 if country=="HR" & year==2012
keep if good==1

***_00: nationally financed

*save "###\2025_craefippaems_2007_2023_country_level_data_s18_00.dta", replace
*use  "###\2025_craefippaems_2007_2023_contract_level_data.dta, clear"

keep if eu==1

gen     cr0=0
replace cr0=1 if cr==0
gen     cr1=0
replace cr1=1 if cr==1
gen     crx0=0
replace crx0=1 if crx==0
gen     crx1=0
replace crx1=1 if crx==1

gen     eu0=0
replace eu0=1 if eu==0
gen     eu1=0
replace eu1=1 if eu==1

gen     lti0=0
replace lti0=1 if lti==0
gen     lti1=0
replace lti1=1 if lti==1

gen     gpa0=0
replace gpa0=1 if gpa==0
gen     gpa1=0
replace gpa1=1 if gpa==1

gen     eauction0=0
replace eauction0=1 if eauction==0
gen     eauction1=0
replace eauction1=1 if eauction==1

gen ncv_mill=ncvalue/1000000
gen ncv_millcr0= ncv_mill if cr==0
gen ncv_millcr1= ncv_mill if cr==1

gen cnum=1
gen eu_c=1
***eu_c[1]: EU financed
keep if goodfw==1
keep if eu_countries_d==1
keep if year>2006
keep country cr0 cr1 crx0 crx1 eu0 eu1 lti0 lti1 gpa0 gpa1 eauction0 eauction1 ncv_mill ncv_millcr0 ncv_millcr1 cnum eu_c eu_countries year
collapse (first) country eu_c (sum) cr0 cr1 crx0 crx1 eu0 eu1 lti0 lti1 gpa0 gpa1 eauction0 eauction1 ncv_mill ncv_millcr0 ncv_millcr1 cnum, by (eu_countries year)

format year %8.0g

gen crr =cr1/(cr1+cr0)
gen eur =1
gen crxr=crx1/(crx1+crx0)
gen ltir=lti1/(lti1+lti0)
gen gpar=gpa1/(gpa1+gpa0)
gen eauctionr=eauction1/(eauction1 + eauction0)
gen ncv_crr=ncv_millcr1/ncv_mill
gen lnncv=ln(ncv_mill)

gen cgroups=.
replace cgroups=1  if country=="BG"
replace cgroups=1  if country=="CZ"
replace cgroups=1  if country=="EE"
replace cgroups=1  if country=="HR"
replace cgroups=1  if country=="HU"
replace cgroups=1  if country=="LT"
replace cgroups=1  if country=="LV"
replace cgroups=1  if country=="PL"
replace cgroups=1  if country=="RO"
replace cgroups=1  if country=="SI"
replace cgroups=1  if country=="SK"

replace cgroups=2  if country=="AT"
replace cgroups=2  if country=="BE"
replace cgroups=2  if country=="DE"
replace cgroups=2  if country=="DK"
replace cgroups=2  if country=="FI"
replace cgroups=2  if country=="FR"
replace cgroups=2  if country=="IE"
replace cgroups=2  if country=="LU"
replace cgroups=2  if country=="NL"
replace cgroups=2  if country=="SE"
replace cgroups=2  if country=="UK"

replace cgroups=3  if country=="CY"
replace cgroups=3  if country=="ES"
replace cgroups=3  if country=="GR"
replace cgroups=3  if country=="IT"
replace cgroups=3  if country=="MT"
replace cgroups=3  if country=="PT"

***new member states, 11 countries

gen     nms=.
replace nms=0  if cgroups==2 | cgroups==3
replace nms=1  if cgroups==1

**sec (south-european countries), wec

gen     sec=.
replace sec=0  if cgroups==2  | cgroups==1
replace sec=1  if cgroups==3

gen     wec=.
replace wec=0  if cgroups==1  | cgroups==3 
replace wec=1  if cgroups==2

gen     good=1
replace good=0 if country=="HR" & year==2007
replace good=0 if country=="HR" & year==2010
replace good=0 if country=="HR" & year==2011
replace good=0 if country=="HR" & year==2012
keep if good==1

***_01: EU financed

*save "###\2025_craefippaems_2007_2023_country_level_data_s18_01.dta", replace

*use          "###\2025_craefippaems_2007_2023_country_level_data_s18_02.dta", clear
*append using "###\2025_craefippaems_2007_2023_country_level_data_s18_00.dta" "###\2025_craefippaems_2007_2023_country_level_data_s18_01.dta"
*save         "###\2025_craefippaems_2007_2023_country_level_data.dta", replace

***merging the world bank's gdp per capita (ppp) dataset

clear
*import excel "###\2025_craefippaems_2007_2023_wb_gdp_data_220725.xlsx", sheet("Data") firstrow
keep if country_num!=.
sort country_num
reshape long y, i(country_num) j(year)
rename y gdp_p_cap_ppp
*save         "###\2025_craefippaems_2007_2023_wb_gdp_p_cap_ppp.dta", replace

***merging wb and eu_ted datasets

*use "###\2025_craefippaems_2007_2023_country_level_data.dta", clear
encode country, gen(country_num)
sort country_num year
*save "###\2025_craefippaems_2007_2023_country_level_data.dta", replace

*use                              "###\2025_craefippaems_2007_2023_country_level_data.dta", clear
*merge m:1 country_num year using "###\2025_craefippaems_2007_2023_wb_gdp_p_cap_ppp.dta"

gen lncrr =ln(crr)
gen lncrr_eu0 =ln(crr_eu0)
gen lncrr_eu1 =ln(crr_eu1)

gen lncrxr=ln(crxr)
gen lncrxr_eu0=ln(crxr_eu0)
gen lncrxr_eu1=ln(crxr_eu1)

gen lnltir    =ln(ltir)
gen lnltir_eu0=ln(ltir_eu0)
gen lnltir_eu1=ln(ltir_eu1)

gen lneur= ln(eur)

gen lneauctionr    =ln(eauctionr)
gen lneauctionr_eu0=ln(eauctionr_eu0)
gen lneauctionr_eu1=ln(eauctionr_eu1)

gen lngpar      =ln(gpar)
gen lngpar_eu0  =ln(gpar_eu0)
gen lngpar_eu1  =ln(gpar_eu1)

gen lncnum      =ln(cnum)
gen lncnum_eu0  =ln(cnum_eu0)
gen lncnum_eu1  =ln(cnum_eu1)

gen lnncv_crr     =ln(ncv_crr)
gen lnncv_crr_eu0 =ln(ncv_crr_eu0)
gen lnncv_crr_eu1 =ln(ncv_crr_eu1)

gen lngdp=ln(gdp_p_cap_ppp)

drop _merge
keep if year>2006
sort country year eu_c
*save "###\2025_craefippaems_2007_2023_country_level_data.dta", replace


***
***tables & figures for the country level analysis
***

*use  "###\2025_craefippaems_2007_2023_country_level_data.dta", clear

***
***Table 4.1.2
***

gen     unsat_rate    =0 if crr <0.2
replace unsat_rate    =1 if crr>=0.2
gen     unsat_rate_eu0=0 if crr_eu0 <0.2
replace unsat_rate_eu0=1 if crr_eu0>=0.2
gen     unsat_rate_eu1=0 if crr_eu1 <0.2
replace unsat_rate_eu1=1 if crr_eu1>=0.2

tab unsat_rate cgroups if eu_c==2 & good==1, col
tab unsat_rate cgroups if eu_c==1 & good==1, col
tab unsat_rate cgroups if eu_c==0 & good==1, col

***scatterplots

*cgroups[1]: NMS
*cgroups[2]: WEC
*cgroups[3]: SEC

***
***Figures 4.1.2a - 4.1.2d
***

***
***crr & lnncv, groups: eu0 vs eu1, where: all nms wec sec
***

drop eu_benchmark2
gen eu_benchmark2=0.2 if lnncv>=0

graph twoway (scatter crr lnncv if good==1 & eu_c==0  & cnum>12 & year>2006, msymbol(Oh) mcolor(gray)) (scatter crr lnncv if good==1 & eu_c==1 & cnum>12  & year>2006, msymbol(+) mcolor(black)) (line eu_benchmark2 lnncv if lnncv>=0, lcolor(black*0.7)) ||, xlabel(1(1)11, nogrid labsize(medium)) legend(size(medium) position(6) rows(2) label (1 Nationally Funded Contracts) label (2 EU Funded Contracts) label (3 Benchmark: unsatisfactory level [CRR≥0.2] set by EU Commission)) ytitle("CRR", size(medium)) xtitle("LNNCV", size(medium)) ylabel(0(0.1)1, nogrid labsize(medium)) graphregion( color(white))
*graph export "###\f412a_scatter_crr_eu_lnncv_all_eu.png", as(png) name("Graph") replace
pwcorr crr lnncv if good==1 & eu_c==0  & cnum>12 & year>2006, sig 
pwcorr crr lnncv if good==1 & eu_c==1  & cnum>12 & year>2006, sig 

graph twoway (scatter crr lnncv if cgroups==1 & good==1 & eu_c==0  & cnum>12 & year>2006, msymbol(Oh) mcolor(gray)) (scatter crr lnncv if cgroups==1 & good==1 & eu_c==1 & cnum>12 & year>2006, msymbol(+) mcolor(black)) (line eu_benchmark2 lnncv if lnncv>=0, lcolor(black*0.6)) ||, xlabel(1(1)11, nogrid labsize(medium)) legend(size(medium) position(6) rows(2) label (1 Nationally Funded Contracts) label (2 EU Funded Contracts) label (3 Benchmark: unsatisfactory level [CRR≥0.2] set by EU Commission)) ytitle("CRR", size(medium)) xtitle("LNNCV", size(medium)) ylabel(0(0.1)1, nogrid labsize(medium)) graphregion( color(white))
*graph export "###\f412b_scatter_crr_eu_lnncv_all_eu.png", as(png) name("Graph") replace
pwcorr crr lnncv if cgroups==1 & good==1 & eu_c==0  & cnum>12 & year>2006, sig
pwcorr crr lnncv if cgroups==1 & good==1 & eu_c==1  & cnum>12 & year>2006, sig 

graph twoway (scatter crr lnncv if cgroups==2 & good==1 & eu_c==0  & cnum>12 & year>2006, msymbol(Oh) mcolor(gray)) (scatter crr lnncv if cgroups==2 & good==1 & eu_c==1 & cnum>12 & year>2006, msymbol(+) mcolor(black)) (line eu_benchmark2 lnncv if lnncv>=0, lcolor(black*0.6)) ||, xlabel(1(1)11, nogrid labsize(medium)) legend(size(medium) position(6) rows(2) label (1 Nationally Funded Contracts) label (2 EU Funded Contracts) label (3 Benchmark: unsatisfactory level [CRR≥0.2] set by EU Commission)) ytitle("CRR", size(medium)) xtitle("LNNCV", size(medium)) ylabel(0(0.1)1, nogrid labsize(medium)) graphregion( color(white))
*graph export "###\f412c_scatter_crr_eu_lnncv_all_eu.png", as(png) name("Graph") replace
pwcorr crr lnncv if cgroups==2 & good==1 & eu_c==0  & cnum>12 & year>2006, sig
pwcorr crr lnncv if cgroups==2 & good==1 & eu_c==1  & cnum>12 & year>2006, sig 

graph twoway (scatter crr lnncv if cgroups==3 & good==1 & eu_c==1  & cnum>12 & year>2006, msymbol(Oh) mcolor(gray)) (scatter crr lnncv if cgroups==3 & good==1 & eu_c==0 & cnum>12 & year>2006, msymbol(+) mcolor(black)) (line eu_benchmark2 lnncv if lnncv>=0, lcolor(black*0.6)) ||, xlabel(1(1)11, nogrid labsize(medium)) legend(size(medium) position(6) rows(2) label (1 Nationally Funded Contracts) label (2 EU Funded Contracts) label (3 Benchmark: unsatisfactory level [CRR≥0.2] set by EU Commission)) ytitle("CRR", size(medium)) xtitle("LNNCV", size(medium)) ylabel(0(0.1)1, nogrid labsize(medium)) graphregion(color(white))
*graph export "###\f412d_scatter_crr_eu_lnncv_all_eu.png", as(png) name("Graph") replace
pwcorr crr lnncv if cgroups==3 & good==1 & eu_c==0  & cnum>12 & year>2006, sig
pwcorr crr lnncv if cgroups==3 & good==1 & eu_c==1  & cnum>12 & year>2006, sig 

***
***Figures 4.1.3a - 4.1.3b
***

***
***crr & lnncv, groups: cgroups, where: all eu1 eu0
***

graph twoway (scatter crr lnncv if good==1 & cgroups==1 & eu_c==1 & cnum>12 & year>2006, msymbol(oh) mcolor(black*0.8)) (scatter crr lnncv if good==1 & cgroups==2 & eu_c==1 & cnum>12 & year>2006, msymbol(t) mcolor(black)) (scatter crr lnncv if good==1 & cgroups==3 & eu_c==1 & cnum>12 & year>2006, msymbol(X) mcolor(black*0.4)) (line eu_benchmark2 lnncv if lnncv>=0, lcolor(black*0.6))||, xlabel(1(1)11, nogrid labsize(medium)) legend(size(small) position(6) rows(2) label (1 New Member States) label (2 Western European Countries) label (3 Southern European Countries) label (4 Benchmark: unsatisfactory level [CRR≥0.2] set by EU Commission)) ytitle("CRR", size(medium)) xtitle("LNNCV", size(medium))  ylabel(0(0.1)1, nogrid labsize(medium)) graphregion( color(white))
*graph export "###\f413a_scatter_crr_eu_lnncv_all_eu.png", as(png) name("Graph") replace
pwcorr crr lnncv if cgroups==1 & good==1 & eu_c==1 & cnum>12 & year>2006, sig
pwcorr crr lnncv if cgroups==2 & good==1 & eu_c==1 & cnum>12 & year>2006, sig
pwcorr crr lnncv if cgroups==3 & good==1 & eu_c==1 & cnum>12 & year>2006, sig 

graph twoway (scatter crr lnncv if good==1 & cgroups==1 & eu_c==0 & cnum>12, msymbol(oh) mcolor(black*0.8)) (scatter crr lnncv if good==1 & cgroups==2 & eu_c==0 & cnum>12, msymbol(t) mcolor(black)) (scatter crr lnncv if good==1 & cgroups==3 & eu_c==0 & cnum>12, msymbol(X) mcolor(black*0.4)) (line eu_benchmark2 lnncv if lnncv>=0, lcolor(black*0.6))||, xlabel(1(1)11, nogrid labsize(medium)) legend(size(small) position(6) rows(2) label (1 Nationally Funded Contracts) label (1 New Member States) label (2 Western European Countries) label (3 Southern European Countries) label (4 Benchmark: unsatisfactory level [CRR≥0.2] set by EU Commission)) ytitle("CRR", size(medium)) xtitle("LNNCV", size(medium)) ylabel(0(0.1)1, nogrid labsize(medium)) graphregion( color(white))
*graph export "###\f413b_scatter_crr_eu_lnncv_all_eu.png", as(png) name("Graph") replace
pwcorr crr lnncv if cgroups==1 & good==1 & eu_c==0 & cnum>12 & year>2006, sig
pwcorr crr lnncv if cgroups==2 & good==1 & eu_c==0 & cnum>12 & year>2006, sig
pwcorr crr lnncv if cgroups==3 & good==1 & eu_c==0 & cnum>12 & year>2006, sig 

***
***Figures 4.1.4a - 4.1.4d
***

***
***crr & ncv_crr, groups: cgroups, where: eu1 eu0
***

drop eu_benchmark2
gen  eu_benchmark2=0.2 if ncv_crr>=0 & ncv_crr<=0.7

graph twoway (scatter crr ncv_crr if good==1 & cgroups==1 & eu_c==1 & cnum>12 & ncv_crr<0.7 & year>2006, msymbol(oh) mcolor(black*0.8)) (scatter crr ncv_crr if good==1 & cgroups==2 & eu_c==1 & cnum>12 & ncv_crr<0.7 & year>2006, msymbol(t) mcolor(black)) (scatter crr ncv_crr if good==1 & cgroups==3 & eu_c==1 & cnum>12 & ncv_crr<0.7 & year>2006, msymbol(X) mcolor(black*0.4)) (line eu_benchmark2 ncv_crr if ncv_crr<0.7, lcolor(black*0.6)) ||, xlabel(0(0.1)0.7, nogrid labsize(medium)) legend(size(small) position(6) rows (2) label (1 New Member States) label (2 Western European Countries) label (3 Southern European Countries) label (4 Benchmark: unsatisfactory level [CRR≥0.2] set by EU Commission)) ytitle("CRR", size(medium)) xtitle("NCV_CRR", size(medium)) ylabel(0(0.1)1, nogrid labsize(medium)) graphregion( color(white))
*graph export "###\f414a_scatter_crr_ncv_crr_cgroups_eu1.png", as(png) name("Graph") replace

pwcorr crr ncv_crr if              good==1 & eu_c==1 & cnum>12 & year>2006, sig
pwcorr crr ncv_crr if cgroups==1 & good==1 & eu_c==1 & cnum>12 & year>2006 & ncv_crr<0.7, sig
pwcorr crr ncv_crr if cgroups==2 & good==1 & eu_c==1 & cnum>12 & year>2006 & ncv_crr<0.7, sig
pwcorr crr ncv_crr if cgroups==3 & good==1 & eu_c==1 & cnum>12 & year>2006 & ncv_crr<0.7, sig

graph twoway (scatter crr ncv_crr if good==1 & cgroups==1 & eu_c==0 & cnum>12 & ncv_crr<0.7 & year>2006, msymbol(oh) mcolor(black*0.8)) (scatter crr ncv_crr if good==1 & cgroups==2 & eu_c==0 & cnum>12 & ncv_crr<0.7 & year>2006, msymbol(t) mcolor(black)) (scatter crr ncv_crr if good==1 & cgroups==3 & eu_c==0 & cnum>12 & ncv_crr<0.7 & year>2006, msymbol(X) mcolor(black*0.4)) (line eu_benchmark2 ncv_crr if ncv_crr<0.7, lcolor(black*0.6)) ||, xlabel(0(0.1)0.7, nogrid labsize(medium)) legend(size(small) position(6) rows (2) label (1 New Member States) label (2 Western European Countries) label (3 Southern European Countries) label (4 Benchmark: unsatisfactory level [CRR≥0.2] set by EU Commission)) ytitle("CRR", size(medium)) xtitle("NCV_CRR", size(medium)) ylabel(0(0.1)1, nogrid labsize(medium)) graphregion( color(white))
*graph export "###\f414c_scatter_crr_ncv_crr_cgroups_eu0.png", as(png) name("Graph") replace

pwcorr crr ncv_crr if              good==1 & eu_c==0 & cnum>12 & year>2006, sig
pwcorr crr ncv_crr if cgroups==1 & good==1 & eu_c==0 & cnum>12 & year>2006 & ncv_crr<0.7, sig
pwcorr crr ncv_crr if cgroups==2 & good==1 & eu_c==0 & cnum>12 & year>2006 & ncv_crr<0.7, sig
pwcorr crr ncv_crr if cgroups==3 & good==1 & eu_c==0 & cnum>12 & year>2006 & ncv_crr<0.7, sig

***
***crr & crxr, groups: cgroups, where: eu1 eu0
***

drop eu_benchmark2
gen  eu_benchmark2=0.2 if crxr>=0.1 & crxr<=1

graph twoway (scatter crr crxr if good==1 & cgroups==1 & eu_c==1 & cnum>12 & year>2006, msymbol(oh) mcolor(black*0.8)) (scatter crr crxr if good==1 & cgroups==2 & eu_c==1 & cnum>12 & year>2006, msymbol(t) mcolor(black)) (scatter crr crxr if good==1 & cgroups==3 & eu_c==1 & cnum>12 & year>2006, msymbol(X) mcolor(black*0.4)) (line eu_benchmark2 crxr if crxr>=0.1, lcolor(black*0.6)) ||, xlabel(0.1(0.1)1, nogrid labsize(medium)) legend(size(small) position(6) rows (2) label (1 New Member States) label (2 Western European Countries) label (3 Southern European Countries) label (4 Benchmark: unsatisfactory level [CRR≥0.2] set by EU Commission)) ytitle("CRR", size(medium)) xtitle("CRXR", size(medium)) ylabel(0(0.1)1, nogrid labsize(medium)) graphregion( color(white))
*graph export "###\f414b_scatter_crr_ncv_crr_cgroups_eu1.png", as(png) name("Graph") replace

pwcorr crr crxr if              good==1 & eu_c==1 & cnum>12 & year>2006, sig
pwcorr crr crxr if cgroups==1 & good==1 & eu_c==1 & cnum>12 & year>2006, sig
pwcorr crr crxr if cgroups==2 & good==1 & eu_c==1 & cnum>12 & year>2006, sig
pwcorr crr crxr if cgroups==3 & good==1 & eu_c==1 & cnum>12 & year>2006, sig 

graph twoway (scatter crr crxr if good==1 & cgroups==1 & eu_c==0 & cnum>12, msymbol(oh) mcolor(black*0.8)) (scatter crr crxr if good==1 & cgroups==2 & eu_c==0 & cnum>12, msymbol(t) mcolor(black)) (scatter crr crxr if good==1 & cgroups==3 & eu_c==0 & cnum>12, msymbol(X) mcolor(black*0.4)) (line eu_benchmark2 crxr if crxr>=0.1, lcolor(black*0.6)) ||, xlabel(0.1(0.1)1, nogrid labsize(medium)) legend(size(small) position(6) rows (2) label (1 New Member States) label (2 Western European Countries) label (3 Southern European Countries) label (4 Benchmark: unsatisfactory level [CRR≥0.2] set by EU Commission)) ytitle("CRR", size(medium)) xtitle("CRXR", size(medium)) ylabel(0(0.1)1, nogrid labsize(medium)) graphregion( color(white))
*graph export "###\f414d_scatter_crr_ncv_crr_cgroups_eu0.png", as(png) name("Graph") replace

pwcorr crr crxr if              good==1 & eu_c==0 & cnum>12 & year>2006, sig
pwcorr crr crxr if cgroups==1 & good==1 & eu_c==0 & cnum>12 & year>2006, sig
pwcorr crr crxr if cgroups==2 & good==1 & eu_c==0 & cnum>12 & year>2006, sig
pwcorr crr crxr if cgroups==3 & good==1 & eu_c==0 & cnum>12 & year>2006, sig 

***
***END OF COUNTRY LEVEL ANALYSIS
***


***
***end of do file
***

